#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.TimeZoneConfig;
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TimeZoneConfig : BaseTest 
	{
		private BOL.TimeZoneConfig _testTzc;		

		private readonly BOL.TimeZone _testTimeZone = new BOL.TimeZone( 'A' );
		private const COMMON.DaylightSavingsType TestDaylightSavingsType = COMMON.DaylightSavingsType.UsaStandard;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testTzc = new TimeZoneConfig();
		}

		[TearDown]
		protected void TearDown()
		{
			_testTzc = null;
		}
		
		[Test]
		public void Ctor_Pass()
		{
			Assert.AreEqual( Common.DaylightSavingsType.Unknown, _testTzc.DaylightSavingsType );
			Assert.IsNull( _testTzc.TimeZone );
			Assert.IsTrue( Common.StNullConvert.IsNull( _testTzc.CustomDaylightSavingsStart ) );
			Assert.IsTrue( Common.StNullConvert.IsNull( _testTzc.CustomDaylightSavingsEnd ) );

			Assert.IsTrue( _testTzc.IsRuleBroken( BROKEN.TimeZoneNotSet ) );
			Assert.IsTrue( _testTzc.IsRuleBroken( BROKEN.DaylightSavingsTypeNotSet ) );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void Ctor__Fail() {}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");

			BOL.TimeZoneConfig tstValue = new BOL.TimeZoneConfig(dr);

			Assert.AreEqual(tstValue.TimeZone.ID,System.Convert.ToChar(dr[TABLES.VamcDivision.TimeZoneId]));
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_DataRow_Fail()
		{
			BOL.TimeZoneConfig tstValue = new BOL.TimeZoneConfig(null);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable dt = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");

			BOL.TimeZoneConfig tstValue = new BOL.TimeZoneConfig(dt.Rows[0]);

			DataRow dr = tstValue.LoadDataRowFromThis(dt.NewRow());

			Assert.AreEqual(tstValue.TimeZone.ID,System.Convert.ToChar(dr[TABLES.VamcDivision.TimeZoneId]));
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void LoadDataRowFromThis_Fail()
		{
			this._testTzc.LoadDataRowFromThis(null);
		}

		[Test]
		public void TimeZone_Pass()
		{
			_testTzc.TimeZone = _testTimeZone;

			Assert.AreEqual( _testTimeZone, _testTzc.TimeZone );
			Assert.IsTrue( !_testTzc.IsRuleBroken( BROKEN.TimeZoneNotSet ) );
		}

		[Test]
		public void TimeZone_Fail()
		{
			_testTzc.TimeZone = null;
			Assert.IsTrue( _testTzc.IsRuleBroken( BROKEN.TimeZoneNotSet ) );
		}

		[Test]
		public void DaylightSavingsType_Pass()
		{
			_testTzc.DaylightSavingsType = TestDaylightSavingsType;
			
			Assert.AreEqual( TestDaylightSavingsType, _testTzc.DaylightSavingsType );
			Assert.IsTrue( !_testTzc.IsRuleBroken( BROKEN.DaylightSavingsTypeNotSet ) );
		}

		[Test]
		public void DaylightSavingsType_Fail()
		{
			_testTzc.DaylightSavingsType = Common.DaylightSavingsType.Unknown;
			Assert.IsTrue( _testTzc.IsRuleBroken( BROKEN.DaylightSavingsTypeNotSet ) );
		}

		[Test]
		public void CustomDaylightSavingsStart_Pass()
		{
			System.DateTime tstValue = this._testTzc.CustomDaylightSavingsStart;

			Assert.AreEqual(System.DateTime.MinValue, tstValue, "Default");

			tstValue = System.DateTime.Now;
			this._testTzc.CustomDaylightSavingsStart = tstValue;

			Assert.AreEqual(tstValue, this._testTzc.CustomDaylightSavingsStart, "ManualSet");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CustomDaylightSavingsStart_Fail()
		{
		}

		[Test]
		public void CustomDaylightSavingsEnd_Pass()
		{
			System.DateTime tstValue = this._testTzc.CustomDaylightSavingsEnd;

			Assert.AreEqual(System.DateTime.MinValue, tstValue, "Default");

			tstValue = System.DateTime.Now;
			this._testTzc.CustomDaylightSavingsEnd = tstValue;

			Assert.AreEqual(tstValue, this._testTzc.CustomDaylightSavingsEnd, "ManualSet");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CustomDaylightSavingsEnd_Fail()
		{
		}
	}
}
#endif
